﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using BaiqiSoft.HtmlEditorControl;

namespace Demo
{
    public partial class frmMain : Form
    {
        public frmMain()
        {
            InitializeComponent();

            //Added to support default instance behavour in C#
            if (defaultInstance == null)
                defaultInstance = this;
        }

        #region Default Instance

        private static frmMain defaultInstance;

        public static frmMain Default
        {
            get
            {
                if (defaultInstance == null)
                {
                    defaultInstance = new frmMain();
                    defaultInstance.FormClosed += new FormClosedEventHandler(defaultInstance_FormClosed);
                }

                return defaultInstance;
            }
        }

        static void defaultInstance_FormClosed(object sender, FormClosedEventArgs e)
        {
            defaultInstance = null;
        }

        #endregion

        private void frmMain_Load(object sender, EventArgs e)
        {
            frmMain_Resize(this, EventArgs.Empty);
            HtmlEditor1.LicenseKey = "Enter you license key here";
            HtmlEditor1.ToolbarButtons.SaveAs.Visible = false;
            //Load German dictionaries
            //HtmlEditor1.SpellingOptions.DictionaryFile = new DictionaryFile("Dictionaries\\de_DE_frami.aff", "Dictionaries\\de_DE_frami.dic");
            HtmlEditor1.Focus();
        }

        private void HtmlEditor1_SpellingOptionsButtonClick(object sender, CancelEventArgs e)
        {
            //You can show your own Spelling Options window by set the Cancel property to True.
            //e.Cancel = true;
        }

        private void frmMain_Resize(object sender, EventArgs e)
        {
            HtmlEditor1.Location = new Point(0, menuStrip1.Height);
            HtmlEditor1.Size = new Size(ClientSize.Width, ClientSize.Height - menuStrip1.Height);
        }

        private void HtmlEditor1_UpdateUI(object sender, EventArgs e)
        {
            //Edit menu
            btnUndo.Enabled = HtmlEditor1.CanUndo;
            btnRedo.Enabled = HtmlEditor1.CanRedo;
            btnCut.Enabled = HtmlEditor1.Selection.CanCut;
            btnCopy.Enabled = HtmlEditor1.Selection.CanCopy;
            btnPaste.Enabled = HtmlEditor1.Selection.CanPaste;
            btnDelete.Enabled = HtmlEditor1.Selection.CanDelete;
            //Insert menu
            if (HtmlEditor1.EditorMode == EditorMode.Design)
            {
                btnPicture.Enabled = true;
                btnHorizontalLine.Enabled = true;
                btnSymbol.Enabled = true;
                btnHyperlink.Enabled = true;
            }
            else
            {
                btnPicture.Enabled = false;
                btnHorizontalLine.Enabled = false;
                btnSymbol.Enabled = false;
                btnHyperlink.Enabled = false;
            }
        }

        private void HtmlEditor1_ToolbarButtonClick(object sender, ToolbarButtonEventArgs e)
        {
            //switch (e.Button)
            //{
            //    case ToolbarButton.NewFile:
            //        //Set Handled to true to cancel the default processing.
            //        e.Handled = true;
            //        //Before creating a new page, we may have to do something.
            //        if (MessageBox.Show("So you want to create a new page?", "Info", MessageBoxButtons.YesNo) != DialogResult.Yes)
            //        {
            //            return;
            //        }
            //        //Creating a new page by ourselves.
            //        HtmlEditor1.InvokeToolbarButtonClick(e);
            //        break;
            //    case ToolbarButton.OpenFile:
            //        //Set Handled to true to cancel the default processing.
            //        e.Handled = true;
            //        //Opening a document by ourselves.
            //        HtmlEditor1.InvokeToolbarButtonClick(e);
            //        //After finished opening the document, we may have to do something.
            //        MessageBox.Show("Finished opening the document.", "Info", MessageBoxButtons.OK);
            //        break;
            //}
        }

        #region "Menu Items"
        private void btnNew_Click(object sender, EventArgs e)
        {
            ToolbarButtonEventArgs button = new ToolbarButtonEventArgs(ToolbarButton.NewFile);
            HtmlEditor1.InvokeToolbarButtonClick(button);
        }

        private void btnOpen_Click(object sender, EventArgs e)
        {
            ToolbarButtonEventArgs button = new ToolbarButtonEventArgs(ToolbarButton.OpenFile);
            HtmlEditor1.InvokeToolbarButtonClick(button);
        }

        private void btnSave_Click(object sender, EventArgs e)
        {
            ToolbarButtonEventArgs button = new ToolbarButtonEventArgs(ToolbarButton.SaveFile);
            HtmlEditor1.InvokeToolbarButtonClick(button);
        }

        private void btnSaveAs_Click(object sender, EventArgs e)
        {
            ToolbarButtonEventArgs button = new ToolbarButtonEventArgs(ToolbarButton.SaveAs);
            HtmlEditor1.InvokeToolbarButtonClick(button);
        }

        private void btnPageSetup_Click(object sender, EventArgs e)
        {
            HtmlEditor1.ShowPageSetupDialog();
        }

        private void btnPrintPreview_Click(object sender, EventArgs e)
        {
            ToolbarButtonEventArgs button = new ToolbarButtonEventArgs(ToolbarButton.PrintPreview);
            HtmlEditor1.InvokeToolbarButtonClick(button);
        }

        private void btnPrint_Click(object sender, EventArgs e)
        {
            ToolbarButtonEventArgs button = new ToolbarButtonEventArgs(ToolbarButton.Print);
            HtmlEditor1.InvokeToolbarButtonClick(button);
        }

        private void btnExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnUndo_Click(object sender, EventArgs e)
        {
            ToolbarButtonEventArgs button = new ToolbarButtonEventArgs(ToolbarButton.Undo);
            HtmlEditor1.InvokeToolbarButtonClick(button);
        }

        private void btnRedo_Click(object sender, EventArgs e)
        {
            ToolbarButtonEventArgs button = new ToolbarButtonEventArgs(ToolbarButton.Redo);
            HtmlEditor1.InvokeToolbarButtonClick(button);
        }

        private void btnCut_Click(object sender, EventArgs e)
        {
            ToolbarButtonEventArgs button = new ToolbarButtonEventArgs(ToolbarButton.Cut);
            HtmlEditor1.InvokeToolbarButtonClick(button);
        }

        private void btnCopy_Click(object sender, EventArgs e)
        {
            ToolbarButtonEventArgs button = new ToolbarButtonEventArgs(ToolbarButton.Copy);
            HtmlEditor1.InvokeToolbarButtonClick(button);
        }

        private void btnPaste_Click(object sender, EventArgs e)
        {
            ToolbarButtonEventArgs button = new ToolbarButtonEventArgs(ToolbarButton.Paste);
            HtmlEditor1.InvokeToolbarButtonClick(button);
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            HtmlEditor1.Selection.Delete();
        }

        private void btnSelectAll_Click(object sender, EventArgs e)
        {
            ToolbarButtonEventArgs button = new ToolbarButtonEventArgs(ToolbarButton.SelectAll);
            HtmlEditor1.InvokeToolbarButtonClick(button);
        }

        private void btnPicture_Click(object sender, EventArgs e)
        {
            ToolbarButtonEventArgs button = new ToolbarButtonEventArgs(ToolbarButton.InsertPicture);
            HtmlEditor1.InvokeToolbarButtonClick(button);
        }

        private void btnHorizontalLine_Click(object sender, EventArgs e)
        {
            ToolbarButtonEventArgs button = new ToolbarButtonEventArgs(ToolbarButton.InsertHorizontalLine);
            HtmlEditor1.InvokeToolbarButtonClick(button);
        }

        private void btnSymbol_Click(object sender, EventArgs e)
        {
            ToolbarButtonEventArgs button = new ToolbarButtonEventArgs(ToolbarButton.InsertSymbol);
            HtmlEditor1.InvokeToolbarButtonClick(button);
        }

        private void btnHyperlink_Click(object sender, EventArgs e)
        {
            ToolbarButtonEventArgs button = new ToolbarButtonEventArgs(ToolbarButton.InsertHyperlink);
            HtmlEditor1.InvokeToolbarButtonClick(button);
        }

        private void btnHelp_Click(object sender, EventArgs e)
        {
            HtmlEditor .OpenWebLink ("http://www.mysofttool.com/help/htmleditor");
        }

        private void btnCheckUpdates_Click(object sender, EventArgs e)
        {
            HtmlEditor.OpenWebLink("http://www.mysofttool.com/net-winforms-html-editor-control");
        }

        private void btnPurchase_Click(object sender, EventArgs e)
        {
            HtmlEditor.OpenWebLink("http://www.mysofttool.com/purchase");
        }

        private void btnAbout_Click(object sender, EventArgs e)
        {
            HtmlEditor1.AboutBox();
        }

        private void btnStyleSheetLinks_Click(object sender, EventArgs e)
        {
            frmLinkStyleSheet.Default.ShowDialog();
        }
        #endregion

    }
}
